/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.talhanation.smallships.client.render.RenderBanner;
import com.talhanation.smallships.entities.AbstractSailBoat;
import com.talhanation.smallships.entities.TNBoatEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBannerUser
extends AbstractSailBoat {
    private static final DataParameter<Boolean> HAS_BANNER = EntityDataManager.func_187226_a(AbstractSailBoat.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<ItemStack> BANNER = EntityDataManager.func_187226_a(AbstractBannerUser.class, (IDataSerializer)DataSerializers.field_187196_f);
    private float bannerWaveAngle;
    private float prevBannerWaveAngle;

    public AbstractBannerUser(EntityType<? extends TNBoatEntity> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_BANNER, (Object)false);
        this.field_70180_af.func_187214_a(BANNER, (Object)Items.field_196191_eg.func_190903_i());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevBannerWaveAngle = this.bannerWaveAngle;
        this.bannerWaveAngle = (float)Math.sin(this.getBannerWaveSpeed() * (float)this.field_70173_aa) * this.getBannerWaveFactor();
    }

    @Override
    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_218657_a("banner", (INBT)this.getBanner().serializeNBT());
        nbt.func_74757_a("hasbanner", this.getHasBanner());
    }

    @Override
    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        INBT banner = nbt.func_74781_a("banner");
        if (banner instanceof CompoundNBT) {
            this.field_70180_af.func_187227_b(HAS_BANNER, (Object)true);
            this.field_70180_af.func_187227_b(BANNER, (Object)ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)banner)));
        }
    }

    public boolean getHasBanner() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BANNER);
    }

    public ItemStack getBanner() {
        return (ItemStack)this.field_70180_af.func_187225_a(BANNER);
    }

    public float getBannerWaveFactor() {
        return this.field_70170_p.func_72896_J() ? 4.5f : 3.0f;
    }

    public float getBannerWaveSpeed() {
        return this.field_70170_p.func_72896_J() ? 0.55f : 0.25f;
    }

    public float getBannerWaveAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevBannerWaveAngle, (float)this.bannerWaveAngle);
    }

    public void setBanner(PlayerEntity player, ItemStack banner) {
        this.playBannerSound();
        this.field_70180_af.func_187227_b(HAS_BANNER, (Object)true);
        this.field_70180_af.func_187227_b(BANNER, (Object)banner.func_77946_l());
        if (!player.func_184812_l_()) {
            banner.func_190918_g(1);
        }
    }

    public void playBannerSound() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_() + 4.0, this.func_226281_cx_(), SoundEvents.field_187550_ag, this.func_184176_by(), 15.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
    }

    public boolean onInteractionWithBanner(ItemStack banner, PlayerEntity player) {
        if (this.getHasBanner()) {
            this.dropBanner();
        }
        this.setBanner(player, banner);
        return true;
    }

    public void onInteractionWithShears(PlayerEntity playerEntity) {
        if (this.getHasBanner()) {
            this.dropBanner();
            this.field_70180_af.func_187227_b(HAS_BANNER, (Object)false);
        }
    }

    public void renderBanner(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
        if (this.getHasBanner()) {
            RenderBanner.renderBanner(this, partialTicks, matrixStack, buffer, this.getBanner(), packedLight, BannerTileEntityRenderer.func_228836_a_());
        }
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void dropBanner() {
        if (this.getHasBanner()) {
            this.getBanner().func_190920_e(1);
            this.func_70099_a(this.getBanner(), 3.0f);
        }
    }
}

